<?php
include 'db.php';

$buttonvals = $_POST['buttonvals'] ?? '';
$sortbys = $_POST['sortbys'] ?? '';
$invoice = trim($_POST['invoice'] ?? '');

$query = "SELECT 
            est.estimate_id,
            est.Estimate_no,
            est.user_id,
            est.Created_date,
            est.Grand_total,
            est.Action_status,
            c.displayname,
            c.phoneno,
            GROUP_CONCAT(DISTINCT p.Product_name ORDER BY p.Product_name SEPARATOR '|') AS product_names,
            GROUP_CONCAT(DISTINCT p.Product_image ORDER BY p.Product_image SEPARATOR '|') AS product_images,
            (SELECT COUNT(*) FROM estimate_data WHERE estimate_data.estimate_id = est.estimate_id AND estimate_data.Delete_status = 0) AS total_products
          FROM 
            estimate est
          INNER JOIN 
            customer c 
          ON 
            c.id = est.user_id 
          INNER JOIN 
            estimate_data ed 
          ON 
            ed.estimate_id = est.estimate_id AND ed.Delete_status = 0
          INNER JOIN 
            product p 
          ON 
            p.Product_id = ed.Product_id
          WHERE 
            est.Delete_status = '0'";

// Filter by button values
if ($buttonvals == '3') {
    $today = date('Y-m-d');
    $query .= " AND est.Created_date = '$today'";
} elseif ($buttonvals == '4') {
    $yesterday = date("Y-m-d", strtotime("yesterday"));
    $query .= " AND est.Created_date = '$yesterday'";
} elseif ($buttonvals == '5') {
    $query .= " AND est.Created_date >= DATE_ADD(CURDATE(), INTERVAL -7 DAY)";
} elseif ($buttonvals == '6') { // 1-month filter
    $query .= " AND est.Created_date >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
}

// Filter by invoice or customer details
if (!empty($invoice)) {
    $query .= " AND (LOWER(est.Estimate_no) LIKE '%$invoice%' 
                    OR LOWER(c.displayname) LIKE '%$invoice%' 
                    OR LOWER(c.phoneno) LIKE '%$invoice%')";
}

// Filter by sort status
if (!empty($sortbys)) {
    $query .= " AND est.Action_status = '$sortbys'";
}

$query .= " GROUP BY est.estimate_id ORDER BY est.Created_date DESC";

$result = mysqli_query($conn, $query);

$data = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = [
            'id' => $row['estimate_id'],
            'estimateno' => $row['Estimate_no'],
            'Created_date' => $row['Created_date'],
            'grandtotal' => $row['Grand_total'],
            'status' => $row['Action_status'],
            'displayname' => $row['displayname'],
            'phoneno' => $row['phoneno'],
            'product_names' => !empty($row['product_names']) ? explode('|', $row['product_names']) : [],
            'product_images' => !empty($row['product_images']) ? explode('|', $row['product_images']) : [],
            'totalProducts' => $row['total_products']
        ];
    }
}

echo json_encode($data);
?>
